//
//  RSRequest.h
//  RSKit
//
//  Created by Max Lansing on 1/29/14.
//  Copyright (c) 2014 Retention Science. All rights reserved.
//

#import <Foundation/Foundation.h>

@class RSRequest;

typedef void (^RSRequestCompletionBlock)(RSRequest * request);

@interface RSRequest : NSObject

@property (nonatomic, copy) RSRequestCompletionBlock completion;
@property (nonatomic, readonly) NSURLRequest * urlRequest;
@property (nonatomic, readonly) NSHTTPURLResponse *response;
@property (nonatomic, readonly) NSMutableData *responseData;
@property (nonatomic, readonly) id responseJSON;
@property (nonatomic, readonly) NSError *error;

+ (instancetype)startWithURLRequest:(NSURLRequest *)urlRequest
                         completion:(RSRequestCompletionBlock)completion;


@end
