//
//  RSClient+Private.h
//  RSKit
//
//  Created by Max Lansing on 2/11/14.
//  Copyright (c) 2014 Retention Science. All rights reserved.
//

#import <UIKit/UIKit.h>
#import <CoreLocation/CoreLocation.h>
#import <RSKit/RSKit.h>

/* These version constants are included in message payload and need to be manually updated when appropriate. */
#define RS_WAVE_VERSION @"1.0"
#define RSKIT_VERSION @"1.0.0"

#define RS_WAVE_URL_PRODUCTION [NSURL URLWithString:@"https://waves.retentionscience.com/wave"]
#define RS_WAVE_URL_STAGING [NSURL URLWithString:@"http://localhost:3000/wave"]
#define RS_WAVE_URL_TEST [NSURL URLWithString:@"http://localhost:3000/wave"]


/* Use the constants below to tune the batch processing behavior and provide rate limiting. */

/* Threshold that triggers the flushing of a batch to remote */
#define RS_MIN_BATCH_SIZE 5
/* Max number of events sent per batch */
#define RS_MAX_BATCH_SIZE 20

/* Minimum delay between batch flushing (wait at least this long before flushing if many events are being queued up) */
#define RS_FLUSH_MIN_DELAY_SECONDS 20
/* Max delay before batch flushed, regardless of number of events queued */
#define RS_FLUSH_MAX_DELAY_SECONDS 60



@interface RSClient () {
    NSString * _siteId;
    dispatch_queue_t _serialQueue;
    NSMutableArray * _messageQueue;
    NSMutableDictionary * _deviceInformation;
    NSTimer * _flushTimer;
    NSDate * _lastFlushedAt;
    UIBackgroundTaskIdentifier _flushTaskID;
    NSMutableArray * _currentBatch;
    NSString * _sessionId;
    NSDate * _sessionIdExpiresAt;
    CLLocation * _lastLocation;
    void (^_flushCompletionBlock)(void);
}

- (RSClient *)initWithSiteId:(NSString *)siteId;

- (void)dispatchBackgroundAndWait:(void(^)(void))block;
- (void)dispatchBackground:(void(^)(void))block;
- (void)applicationWillTerminate;
- (void)applicationDidEnterBackground;

@end

@interface RSClient (Private)

@property (readonly) NSString * siteId;
@property (readonly) NSString * sessionId;
@property (readonly) NSDate * sessionIdExpiresAt;
@property (readonly) NSArray * messageQueue;

//These are for tests only!
- (void)clearSession;
- (void)clearMessageQueue;
- (void)setFlushCompletionBlock:(void (^)(void))completion;


@end
