RSKit
======

RSKit is the iOS SDK for Retention Science customers. 

## Getting Started

- Check out the example app for usage and integration demos.
- AppleDoc-generated API documentation is in the docs directory of this repo.
- Complete integration instructions below!

### Adding RSKit to your app

We recommend adding the complete RSKit directory tree to your app's code repo to start.

Once you have RSKit situated within your project's repo, you'll want to drag RSKit.xcodeproj from the Finder into the Frameworks directory of your project.

![screenshot] (http://i.imgur.com/cXw0Yi4.png)

Next, you need to include libRSKit.a in the link phase. Go to your app's Build Phases screen, expand the Link Binary with Libraries section, and click the + button, then add libRSKit.a.

![screenshot] (http://i.imgur.com/PyFGB0U.png)

**We recommend also including AdSupport.framework in the link phase as well.** When AdSupport is available, RSKit will include the quasi-global "advertiser" device ID with tracking messages. Otherwise, RSKit will fall back on the vendor-specific device ID.

Now you need to initialize RSKit at runtime. The preferred place to do this is in your AppDelegate's applicationDidFinishLaunchingWithOptions: method, but it can be done elsewhere if you prefer.

Include the RSKit header:

```objective-c
#import <RSKit/RSKit.h>
```

Boot up RSKit:

```objective-c
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    [RSClient initializeWithSiteId:@"my_rs_site_id"];
    return YES;
}
```

That's it! You're ready to track user behavior.

## Usage

### Event tracking

Events are tracked in RSKit by calling the track:: method at the relevant location in your code:

```objective-c
[[RSClient sharedClient] track:@"viewProduct" properties:@{@"items": @[@{@"sku": @"BIKE123", @"cost": @399.99}]}];
```

Tracking messages are queued until a critical mass is reached, to  keep power consumption to a minimum, and to accomodate situations where connectivity is unavailable. If the app is backgrounded, RSKit will attempt to flush the queue immediately. If the app is terminated while tracking messages are still in the queue, the queue will be persisted to disk. The next time the app is launched, this queue will be loaded, and RSKit will attempt to flush it immediately.

### User identifiers

If your app has a unique key that can identify the current user, we recommend sharing it with RSKit:

```objective-c
[RSClient sharedClient].userId = @"user12345";
```

### Session identifiers

In some cases it is appropriate to assign an identifier to the current RSKit session, for example if the user has been deep-linked into the app via an offer email or web page. 

RSKit sessions have temporal validity intervals, which are expressed as NSTimeIntervals (i.e., seconds). Session identifiers are persisted to disk and will be included in all subsequent tracking messages, including following app termination and re-launches, until they expire.

```objective-c
[[RSClient sharedClient] setSessionId:@"session12345" expiresIn:(60*60*24*7)];
```

### Location awareness

If your app employs location services, you can share that data with Retention Science. RSKit won't start location updates on its own, but if you share a CLLocationManager instance with RSKit, RSKit will include the most recent location data on subsequent tracking messages.

Let's say you have a CLLocationManager instance called _locationManager, and you start location updates:

```objective-c
[_locationManager startUpdatingLocation];
[RSClient sharedClient].locationManager = _locationManager;
```

When you stop location updates, it's a good idea to set the RSClient locationManager property to nil. This is because even accessing stale location data from a CLLocationManager instance will cause the location services icon to appear on the device's status bar, which may be misleading to users in some situations.

```objective-c
[_locationManager stopUpdatingLocation];
[RSClient sharedClient].locationManager = nil;
```


## Developer Notes

RSKit does not have any external dependencies for normal usage. However, there are a couple of dependencies required to generate the documentation you're reading right now.

### AppleDoc

RSKit's Xcode project has a target called Documentation, that uses AppleDoc to generate pretty API documentation. To be able to run this target on your machine, you need to build [AppleDoc] (https://github.com/tomaz/appledoc) and install the appledoc binary at 
```
/usr/local/bin/appledoc
```

### Markdown converter

In order to convert this readme to HTML (so you can read it offline), you need to install the github-markdown gem for your system ruby to use.

```
sudo gem install github-markdown
```

## The End

Thanks for using RSKit!
