/*
 * Decompiled with CFR 0.152.
 */
package com.retentionscience.client;

import android.app.Application;
import android.location.Location;
import android.os.Bundle;
import com.retentionscience.client.RSClient;
import java.util.Random;
import org.json.JSONException;
import org.json.JSONObject;

public class RSUnitTests {
    public static final int OVERRIDE_ALL_NULL = 0;
    public static final int OVERRIDE_ALL_SUCCESS = 1;
    public static final int OVERRIDE_ALL_FAILURE = 2;
    public static final int OVERRIDE_ALL_CACHE = 3;
    private static long s_hashDifferencer = 0L;

    public static void TEST_runBasicImplementationTest() {
        RSUnitTests.TEST_callEvent(0);
        RSUnitTests.TEST_callEventWithLocation(0);
        RSUnitTests.TEST_callEventWithBundle(0);
        RSUnitTests.TEST_callEventWithBundleAndLocation(0);
        RSUnitTests.TEST_callEventWithJSONObject(0);
        RSUnitTests.TEST_callEventWithJSONObjectAndLocation(0);
    }

    public static void TEST_runBasicImplementationCallFailure() {
        RSUnitTests.TEST_callEvent(2);
        RSUnitTests.TEST_callEventWithLocation(2);
        RSUnitTests.TEST_callEventWithBundle(2);
        RSUnitTests.TEST_callEventWithBundleAndLocation(2);
        RSUnitTests.TEST_callEventWithJSONObject(2);
        RSUnitTests.TEST_callEventWithJSONObjectAndLocation(2);
    }

    public static void TEST_initializeRetentionScience(Application application) {
        RSClient.DEBUG_enableDeveloperMode();
        RSClient.initializeWithSiteId("152", application);
        RSClient.enableDebugLogs();
        RSClient.enableVerboseLogs();
        RSClient.setUserId("retentionScience");
        RSClient.setSessionDuration(120);
        RSClient.useGeneratedUUIDs(true);
        RSClient.setMaxCachedEvents(100);
        RSClient.setMaxQueueSize(100);
        RSClient.setSocketTimeout(7000);
        RSClient.setDeviceIdSource("067e6162-3b6f-4ae2-a171-2470b63dff00");
        RSClient.enableDuplicateEventChecking();
        RSClient.setLoopIntervalSpacing(150);
        RSClient.setCachedInQueueTreshold(2);
    }

    public static void TEST_verifyInitializationSuccess(Application application) {
        try {
            RSUnitTests.TEST_initializeRetentionScience(application);
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when initializing RC SDK - " + error.getMessage()));
        }
        if (!RSClient.isInitialized()) {
            throw new AssertionError((Object)"Initialization not successful, something went wrong");
        }
    }

    public static void TEST_callEvent(int override) {
        try {
            if (override == 1) {
                RSClient.DEBUG_enableAllSuccess();
            } else if (override == 2) {
                RSClient.DEBUG_enableAllFailure();
            } else if (override == 0) {
                RSClient.DEBUG_enableAllDefault();
            } else if (override == 3) {
                RSClient.DEBUG_enableAllCacheAndDelete();
            }
            RSClient.track("test event Metadata" + RSUnitTests.fetchHashDifferencer());
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when calling event - " + error.getMessage()));
        }
    }

    public static void TEST_callEventWithLocation(int override) {
        try {
            if (override == 1) {
                RSClient.DEBUG_enableAllSuccess();
            } else if (override == 2) {
                RSClient.DEBUG_enableAllFailure();
            } else if (override == 0) {
                RSClient.DEBUG_enableAllDefault();
            } else if (override == 3) {
                RSClient.DEBUG_enableAllCacheAndDelete();
            }
            Location test_location = new Location("unit_test");
            test_location.setLatitude(37.377166);
            test_location.setLongitude(-122.086966);
            test_location.setTime(RSUnitTests.getSystemTime() - 1000L);
            test_location.setAccuracy(3.0f);
            RSClient.track("test event Metadata" + RSUnitTests.fetchHashDifferencer(), test_location);
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when calling event with location - " + error.getMessage()));
        }
    }

    public static void TEST_callEventWithBundle(int override) {
        try {
            if (override == 1) {
                RSClient.DEBUG_enableAllSuccess();
            } else if (override == 2) {
                RSClient.DEBUG_enableAllFailure();
            } else if (override == 0) {
                RSClient.DEBUG_enableAllDefault();
            } else if (override == 3) {
                RSClient.DEBUG_enableAllCacheAndDelete();
            }
            Bundle testObj = new Bundle();
            testObj.putString("name", "Retention Science Test 1");
            testObj.putLong("test_param_1", (long)RSUnitTests.getRandomNumber(100000000, 999999999));
            testObj.putDouble("test_param_2", (double)(RSUnitTests.getRandomNumber(100000000, 999999999) / 1000));
            testObj.putString("test_param_3", "hello world");
            testObj.putString("name", "Retention Science Test UTF8");
            testObj.putString("Japanese", "\u201e\u00c5\u00ec\u201e\u00c7\u00ec\u201e\u00c5\u00b4\u201e\u00c5\u00b0\u201e\u00c5\u00d8\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
            testObj.putString("Chinese", "\u2030\u03a9\u2020\u00c2\u2022\u03a9\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
            testObj.putString("Korean", "\u00cf\u00ef\u00e0\u00ce\u00d6\u00ef\u00cc\u00ef\u00f2\u00cf\u00d1\u220f\u00cf\u00f6\u00ee");
            testObj.putString("Arabic", "\u0178\u00d6\u00ff\u00b1\u00ff\u2260\u00ff\u00ae\u00ff\u00df \u00ff\u00ae\u00ff\u00df\u0178\u00d1\u00ff\u03c0\u00ff\u00df\u0178\u00d1\u0178\u00d6");
            testObj.putLong("unique_batch_id", RSUnitTests.fetchHashDifferencer());
            RSClient.track("test event Metadata", testObj);
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when calling event with bundle - " + error.getMessage()));
        }
    }

    public static void TEST_callEventWithBundleAndLocation(int override) {
        try {
            if (override == 1) {
                RSClient.DEBUG_enableAllSuccess();
            } else if (override == 2) {
                RSClient.DEBUG_enableAllFailure();
            } else if (override == 0) {
                RSClient.DEBUG_enableAllDefault();
            } else if (override == 3) {
                RSClient.DEBUG_enableAllCacheAndDelete();
            }
            Location test_location = new Location("unit_test");
            test_location.setLatitude(37.377166);
            test_location.setLongitude(-122.086966);
            test_location.setTime(RSUnitTests.getSystemTime() - 1000L);
            test_location.setAccuracy(3.0f);
            Bundle testObj = new Bundle();
            testObj.putString("name", "Retention Science Test 1");
            testObj.putLong("test_param_1", (long)RSUnitTests.getRandomNumber(100000000, 999999999));
            testObj.putDouble("test_param_2", (double)(RSUnitTests.getRandomNumber(100000000, 999999999) / 1000));
            testObj.putString("test_param_3", "hello world");
            testObj.putString("name", "Retention Science Test UTF8");
            testObj.putString("Japanese", "\u201e\u00c5\u00ec\u201e\u00c7\u00ec\u201e\u00c5\u00b4\u201e\u00c5\u00b0\u201e\u00c5\u00d8\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
            testObj.putString("Chinese", "\u2030\u03a9\u2020\u00c2\u2022\u03a9\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
            testObj.putString("Korean", "\u00cf\u00ef\u00e0\u00ce\u00d6\u00ef\u00cc\u00ef\u00f2\u00cf\u00d1\u220f\u00cf\u00f6\u00ee");
            testObj.putString("Arabic", "\u0178\u00d6\u00ff\u00b1\u00ff\u2260\u00ff\u00ae\u00ff\u00df \u00ff\u00ae\u00ff\u00df\u0178\u00d1\u00ff\u03c0\u00ff\u00df\u0178\u00d1\u0178\u00d6");
            testObj.putLong("unique_batch_id", RSUnitTests.fetchHashDifferencer());
            RSClient.track("test event Metadata", testObj, test_location);
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when calling event with bundle & location - " + error.getMessage()));
        }
    }

    public static void TEST_callEventWithJSONObject(int override) {
        try {
            if (override == 1) {
                RSClient.DEBUG_enableAllSuccess();
            } else if (override == 2) {
                RSClient.DEBUG_enableAllFailure();
            } else if (override == 0) {
                RSClient.DEBUG_enableAllDefault();
            } else if (override == 3) {
                RSClient.DEBUG_enableAllCacheAndDelete();
            }
            Location test_location = new Location("unit_test");
            test_location.setLatitude(37.377166);
            test_location.setLongitude(-122.086966);
            test_location.setTime(RSUnitTests.getSystemTime() - 1000L);
            test_location.setAccuracy(3.0f);
            JSONObject testObj = new JSONObject();
            try {
                testObj.put("name", (Object)"Retention Science Test 1");
                testObj.put("test_param_1", RSUnitTests.getRandomNumber(100000000, 999999999));
                testObj.put("test_param_2", RSUnitTests.getRandomNumber(100000000, 999999999) / 1000);
                testObj.put("test_param_3", (Object)"hello world");
                testObj.put("name", (Object)"Retention Science Test UTF8");
                testObj.put("Japanese", (Object)"\u201e\u00c5\u00ec\u201e\u00c7\u00ec\u201e\u00c5\u00b4\u201e\u00c5\u00b0\u201e\u00c5\u00d8\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
                testObj.put("Chinese", (Object)"\u2030\u03a9\u2020\u00c2\u2022\u03a9\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
                testObj.put("Korean", (Object)"\u00cf\u00ef\u00e0\u00ce\u00d6\u00ef\u00cc\u00ef\u00f2\u00cf\u00d1\u220f\u00cf\u00f6\u00ee");
                testObj.put("Arabic", (Object)"\u0178\u00d6\u00ff\u00b1\u00ff\u2260\u00ff\u00ae\u00ff\u00df \u00ff\u00ae\u00ff\u00df\u0178\u00d1\u00ff\u03c0\u00ff\u00df\u0178\u00d1\u0178\u00d6");
                testObj.put("unique_batch_id", RSUnitTests.fetchHashDifferencer());
                RSClient.track("test event Metadata", testObj, test_location);
            }
            catch (JSONException e) {
                e.printStackTrace();
                throw new AssertionError((Object)("Errors encountered when calling event with JSON - " + e.getMessage()));
            }
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when calling event with JSON - " + error.getMessage()));
        }
    }

    public static void TEST_callEventWithJSONObjectAndLocation(int override) {
        try {
            if (override == 1) {
                RSClient.DEBUG_enableAllSuccess();
            } else if (override == 2) {
                RSClient.DEBUG_enableAllFailure();
            } else if (override == 0) {
                RSClient.DEBUG_enableAllDefault();
            } else if (override == 3) {
                RSClient.DEBUG_enableAllCacheAndDelete();
            }
            Location test_location = new Location("unit_test");
            test_location.setLatitude(37.377166);
            test_location.setLongitude(-122.086966);
            test_location.setTime(RSUnitTests.getSystemTime() - 1000L);
            test_location.setAccuracy(3.0f);
            JSONObject testObj = new JSONObject();
            try {
                testObj.put("name", (Object)"Retention Science Test 1");
                testObj.put("test_param_1", RSUnitTests.getRandomNumber(100000000, 999999999));
                testObj.put("test_param_2", RSUnitTests.getRandomNumber(100000000, 999999999) / 1000);
                testObj.put("test_param_3", (Object)"hello world");
                testObj.put("name", (Object)"Retention Science Test UTF8");
                testObj.put("Japanese", (Object)"\u201e\u00c5\u00ec\u201e\u00c7\u00ec\u201e\u00c5\u00b4\u201e\u00c5\u00b0\u201e\u00c5\u00d8\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
                testObj.put("Chinese", (Object)"\u2030\u03a9\u2020\u00c2\u2022\u03a9\u2030\u220f\u00f1\u00c1\u00ef\u00e5");
                testObj.put("Korean", (Object)"\u00cf\u00ef\u00e0\u00ce\u00d6\u00ef\u00cc\u00ef\u00f2\u00cf\u00d1\u220f\u00cf\u00f6\u00ee");
                testObj.put("Arabic", (Object)"\u0178\u00d6\u00ff\u00b1\u00ff\u2260\u00ff\u00ae\u00ff\u00df \u00ff\u00ae\u00ff\u00df\u0178\u00d1\u00ff\u03c0\u00ff\u00df\u0178\u00d1\u0178\u00d6");
                testObj.put("unique_batch_id", RSUnitTests.fetchHashDifferencer());
                RSClient.track("test event Metadata", testObj, test_location);
            }
            catch (JSONException e) {
                e.printStackTrace();
                throw new AssertionError((Object)("Errors encountered when calling event with JSON & location - " + e.getMessage()));
            }
        }
        catch (Error error) {
            throw new AssertionError((Object)("Errors encountered when calling event with JSON & location - " + error.getMessage()));
        }
    }

    private static synchronized long fetchHashDifferencer() {
        return ++s_hashDifferencer;
    }

    private static int getRandomNumber(int min, int max) {
        Random r = new Random();
        return r.nextInt(max - min) + min;
    }

    private static long getSystemTime() {
        long unixTime = System.currentTimeMillis() / 1000L;
        return unixTime;
    }
}

