/*
 * Decompiled with CFR 0.152.
 */
package com.retentionscience.client;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Application;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.location.Location;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.view.Display;
import android.view.WindowManager;
import com.retentionscience.client.RSLogObject;
import com.retentionscience.client.RSThreadFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class RSClient {
    private static int NUMBER_OF_CORES = Runtime.getRuntime().availableProcessors();
    private static int MAX_CACHED_EVENTS = 25 * NUMBER_OF_CORES;
    private static int MAX_CALLS_IN_QUEUE = -1;
    private static int DEFAULT_SOCKET_TIMEOUT_MS = 5000;
    private static boolean SHOW_DEBUG_LOGS = false;
    private static boolean SHOW_VERBOSE_LOGS = false;
    private static boolean ONLY_USE_GENERATED_UUIDS = false;
    protected static final String PRODUCTION_SERVER = "https://waves.retentionscience.com/wave";
    protected static final String DEVELOPEMENT_SERVER = "http://donothingbox.com/wave/wave.php";
    protected static String TARGET_SERVER = "https://waves.retentionscience.com/wave";
    private static int CACHED_IN_QUEUE_TRESHOLD = 10 * NUMBER_OF_CORES;
    private static String DEVICE_ID_SOURCE = null;
    private static String DEVICE_ID = "";
    private static final String RS_SDK_VERSION = "android-1.0.0";
    private static int KEEP_SESSION_ALIVE = 300;
    private static String s_siteId = null;
    private static String s_userId = null;
    protected static Application s_application = null;
    protected static boolean VERIFY_EVENT_IS_NOT_DUPLICATE = false;
    private static int LOOP_INTERVAL_SPACING = 100;
    @SuppressLint(value={"TrulyRandom"})
    private static SecureRandom s_random = new SecureRandom();
    private static final String RETENTION_SCIENCE_KEY = "XQM4DOXKVT";
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static Bundle s_deviceInfoBundle = null;
    private static LinkedBlockingQueue<RSLogObject> s_mainQueue = new LinkedBlockingQueue();
    private static SharedPreferences s_sharedPrefsRS;
    private static ThreadPoolExecutor s_eventThreadPool;
    private static LinkedBlockingQueue<Runnable> s_eventWorkQueue;
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT;
    protected static HttpClient s_httpClient;
    protected static int DEBUG_MODE;

    static {
        s_eventWorkQueue = new LinkedBlockingQueue();
        KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
        DEBUG_MODE = 0;
    }

    public static void initializeWithSiteId(String siteId, Application application) {
        s_siteId = siteId;
        s_application = application;
        RSClient.log("TOTAL CORES: " + NUMBER_OF_CORES);
        s_eventThreadPool = new ThreadPoolExecutor(RSClient.getCoreUsage(), RSClient.getCoreUsage(), 1L, KEEP_ALIVE_TIME_UNIT, s_eventWorkQueue);
        RSThreadFactory s_threadFactory = new RSThreadFactory();
        s_eventThreadPool.setThreadFactory(s_threadFactory);
        RSClient.log("Retention Science Log Initialization complete with sideId: " + s_siteId);
        BasicHttpParams httpParameters = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)DEFAULT_SOCKET_TIMEOUT_MS);
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        SSLSocketFactory sslSocketFactory = SSLSocketFactory.getSocketFactory();
        sslSocketFactory.setHostnameVerifier(SSLSocketFactory.BROWSER_COMPATIBLE_HOSTNAME_VERIFIER);
        registry.register(new Scheme("https", (SocketFactory)sslSocketFactory, 443));
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)httpParameters, registry);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)DEFAULT_SOCKET_TIMEOUT_MS);
        s_httpClient = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)httpParameters);
        RSClient.mainProcessLoop();
        RSClient.retryEventsCachedOnDisk();
    }

    private static void mainProcessLoop() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    if (s_eventThreadPool.getMaximumPoolSize() - s_eventThreadPool.getActiveCount() > 0) {
                        try {
                            RSLogObject logObject = (RSLogObject)s_mainQueue.take();
                            RSClient.transmitTrackingEvent(logObject);
                        }
                        catch (InterruptedException e) {
                            RSClient.log("unable to take from queue");
                            e.printStackTrace();
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(LOOP_INTERVAL_SPACING);
                        continue;
                    }
                    catch (InterruptedException e) {
                        RSClient.log("unable to sleep at the moment, should never happen in this case");
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        thread.start();
    }

    public static void track(final String action) {
        if (RSClient.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RSClient.attachTrackingParametersBundle(action, null, null);
                }
            };
            s_eventThreadPool.execute(runnable);
        } else {
            RSClient.log("RSClient not initialized, so no events can be logged");
        }
    }

    public static void track(final String action, final Bundle data) {
        if (RSClient.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RSClient.attachTrackingParametersBundle(action, data, null);
                }
            };
            s_eventThreadPool.execute(runnable);
        } else {
            RSClient.log("RSClient not initialized, so no events can be logged");
        }
    }

    public static void track(final String action, final JSONObject data) {
        if (RSClient.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RSClient.attachTrackingParametersJSON(action, data, null);
                }
            };
            s_eventThreadPool.execute(runnable);
        } else {
            RSClient.log("RSClient not initialized, so no events can be logged");
        }
    }

    public static void track(final String action, final Location location) {
        if (RSClient.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RSClient.attachTrackingParametersBundle(action, null, location);
                }
            };
            s_eventThreadPool.execute(runnable);
        } else {
            RSClient.log("RSClient not initialized, so no events can be logged");
        }
    }

    public static void track(final String action, final Bundle data, final Location location) {
        if (RSClient.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RSClient.attachTrackingParametersBundle(action, data, location);
                }
            };
            s_eventThreadPool.execute(runnable);
        } else {
            RSClient.log("RSClient not initialized, so no events can be logged");
        }
    }

    public static void track(final String action, final JSONObject data, final Location location) {
        if (RSClient.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    RSClient.attachTrackingParametersJSON(action, data, location);
                }
            };
            s_eventThreadPool.execute(runnable);
        } else {
            RSClient.log("RSClient not initialized, so no events can be logged");
        }
    }

    public static void useGeneratedUUIDs(boolean useGenerated) {
        ONLY_USE_GENERATED_UUIDS = useGenerated;
    }

    public static void setMaxCachedEvents(int maxEvents) {
        MAX_CACHED_EVENTS = maxEvents;
    }

    public static void setSocketTimeout(int socketTimeout) {
        DEFAULT_SOCKET_TIMEOUT_MS = socketTimeout;
    }

    public static void enableDebugLogs() {
        SHOW_DEBUG_LOGS = true;
    }

    public static void enableVerboseLogs() {
        SHOW_VERBOSE_LOGS = true;
    }

    public static void setUserId(String userId) {
        s_userId = userId;
    }

    public static void setSessionDuration(int maxDelay) {
        KEEP_SESSION_ALIVE = maxDelay;
    }

    public static void setMaxQueueSize(int maxSize) {
        MAX_CALLS_IN_QUEUE = maxSize;
    }

    public static void setDeviceIdSource(String source) {
        DEVICE_ID_SOURCE = source;
    }

    public static void enableDuplicateEventChecking() {
        VERIFY_EVENT_IS_NOT_DUPLICATE = true;
    }

    public static void setLoopIntervalSpacing(int ms) {
        if (ms > 100) {
            LOOP_INTERVAL_SPACING = ms;
        } else {
            ms = 100;
        }
    }

    public static void setCachedInQueueTreshold(int queueTreshold) {
        CACHED_IN_QUEUE_TRESHOLD = queueTreshold;
    }

    public static boolean isInitialized() {
        return s_siteId != null && s_application != null;
    }

    private static void log(String print_log) {
        if (SHOW_DEBUG_LOGS) {
            System.out.println("RSClient: " + print_log);
        }
    }

    private static void cacheTrackEvent(final RSLogObject logObject) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (RSClient.getCachedEventsCount() >= MAX_CACHED_EVENTS) {
                    RSClient.log("Max cached events reached. No more will be cached . . . ");
                } else {
                    SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
                    editor.putString("event_" + logObject.getHash(), logObject.getTrackingString());
                    editor.commit();
                }
            }
        };
        s_eventThreadPool.execute(runnable);
    }

    private static void removeCachedTrackEvent(String eventId) {
        String cachedLogObject = RSClient.getSharedPreferencesRS().getString(eventId, "");
        if (cachedLogObject != "") {
            SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
            editor.remove(eventId);
            editor.commit();
        }
    }

    private static void removeCachedTrackEvent(RSLogObject logObject) {
        String cachedLogObject = RSClient.getSharedPreferencesRS().getString("event_" + logObject.getHash(), "");
        if (cachedLogObject != "") {
            SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
            editor.remove("event_" + logObject.getHash());
            editor.commit();
        }
    }

    public static void retryEventsCachedOnDisk() {
        RSClient.log("Retry logging cached events");
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int retryCount = 0;
                Map keys = RSClient.getSharedPreferencesRS().getAll();
                for (Map.Entry entry : keys.entrySet()) {
                    if (!((String)entry.getKey()).contains("event_")) continue;
                    ++retryCount;
                    String json = entry.getValue().toString();
                    try {
                        JSONObject obj = new JSONObject(json);
                        RSClient.log("Total objects in queue: " + s_mainQueue.size());
                        SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
                        editor.remove((String)entry.getKey());
                        editor.commit();
                        RSClient.queueTrackingEvent(obj);
                    }
                    catch (Throwable t) {
                        RSClient.removeCachedTrackEvent((String)entry.getKey());
                        RSClient.log(t.toString());
                    }
                }
                RSClient.log("Retrying " + retryCount + " events from cache");
            }
        };
        s_eventThreadPool.execute(runnable);
    }

    private static boolean isEventInQueue(long hash) {
        for (RSLogObject logObject : s_mainQueue) {
            if (logObject.getHash() != hash) continue;
            return true;
        }
        return false;
    }

    private static synchronized void queueTrackingEvent(JSONObject tracking_data) {
        RSLogObject logObject = new RSLogObject(tracking_data);
        if (VERIFY_EVENT_IS_NOT_DUPLICATE && RSClient.isEventInQueue(logObject.getHash())) {
            return;
        }
        if (MAX_CALLS_IN_QUEUE == -1 || s_mainQueue.size() < MAX_CALLS_IN_QUEUE) {
            s_mainQueue.add(logObject);
            if (s_mainQueue.size() > CACHED_IN_QUEUE_TRESHOLD) {
                RSClient.cacheTrackEvent(logObject);
            }
        } else {
            RSClient.log("Max defined calls in queue reached. No more events will be logged unless the queue clears itself out");
        }
    }

    private static int getCachedEventsCount() {
        Map keys = RSClient.getSharedPreferencesRS().getAll();
        int sharedPrefsSize = keys.entrySet().size();
        if (sharedPrefsSize - 3 > 0) {
            return sharedPrefsSize - 3;
        }
        return 0;
    }

    private static SharedPreferences getSharedPreferencesRS() {
        if (s_sharedPrefsRS != null) {
            return s_sharedPrefsRS;
        }
        s_sharedPrefsRS = RSClient.getApplicationContext().getSharedPreferences("RetentionSciencePref", 0);
        return s_sharedPrefsRS;
    }

    private static void attachTrackingParametersBundle(String action, Bundle data, Location location) {
        if (s_siteId == null) {
            throw new RuntimeException("You have not properly initialized the Retention Science tracking object. Please call initializeWithSiteid");
        }
        Bundle masterParams = RSClient.getMasterParams(action, location);
        RSClient.log("Current build version: " + Build.VERSION.SDK_INT);
        Bundle deviceInfo = Build.VERSION.SDK_INT >= 13 ? RSClient.getDeviceParamsHoneycomb() : RSClient.getDeviceParamsBase();
        JSONObject dataProcessed = RSClient.mergePayloadForActionBundle(masterParams, deviceInfo, data);
        RSClient.queueTrackingEvent(dataProcessed);
    }

    private static void attachTrackingParametersJSON(String action, JSONObject data, Location location) {
        if (s_siteId == null) {
            throw new RuntimeException("You have not properly initialized the Retention Science tracking object. Please call initializeWithSiteid");
        }
        Bundle masterParams = RSClient.getMasterParams(action, location);
        RSClient.log("Current build version: " + Build.VERSION.SDK_INT);
        Bundle deviceInfo = Build.VERSION.SDK_INT >= 13 ? RSClient.getDeviceParamsHoneycomb() : RSClient.getDeviceParamsBase();
        JSONObject dataProcessed = RSClient.mergePayloadForActionJSON(masterParams, deviceInfo, data);
        RSClient.queueTrackingEvent(dataProcessed);
    }

    private static Bundle getMasterParams(String action, Location location) {
        Long now_time = RSClient.getSystemTime();
        Bundle masterParams = new Bundle();
        masterParams.putString("rsci_vid", RSClient.getUniqueDeviceId());
        masterParams.putString("session_key", RSClient.getSessionKey(now_time));
        masterParams.putString("action", action);
        if (s_userId != null) {
            masterParams.putString("user_id", s_userId);
        }
        masterParams.putString("site_id", s_siteId);
        masterParams.putString("language", Locale.getDefault().toString());
        masterParams.putLong("timestamp", now_time.longValue());
        if (location != null) {
            Bundle bundleLocation = new Bundle();
            bundleLocation.putString("latitude", String.valueOf(location.getLatitude()));
            bundleLocation.putString("longitude", String.valueOf(location.getLongitude()));
            long age = 0L;
            if (RSClient.getSystemTime() > location.getTime()) {
                age = RSClient.getSystemTime() - location.getTime();
            }
            bundleLocation.putString("age", String.valueOf(age));
            bundleLocation.putString("accuracy", String.valueOf(location.getAccuracy()));
            masterParams.putBundle("location", bundleLocation);
        }
        if (DEVICE_ID_SOURCE != null) {
            masterParams.putString("device_id_source", DEVICE_ID_SOURCE);
        }
        return masterParams;
    }

    private static Bundle getDeviceParamsBase() {
        if (s_deviceInfoBundle != null) {
            return s_deviceInfoBundle;
        }
        Bundle deviceInfo = new Bundle();
        WindowManager wm = (WindowManager)s_application.getApplicationContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        TelephonyManager manager = (TelephonyManager)s_application.getApplicationContext().getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        deviceInfo.putString("screen_width", String.valueOf(display.getWidth()));
        deviceInfo.putString("screen_height", String.valueOf(display.getHeight()));
        deviceInfo.putString("carrier", carrierName);
        deviceInfo.putString("api_version", String.valueOf(Build.VERSION.SDK_INT));
        deviceInfo.putString("device", Build.DEVICE);
        deviceInfo.putString("manufacturer", Build.MANUFACTURER);
        deviceInfo.putString("model", Build.MODEL);
        deviceInfo.putString("product", Build.PRODUCT);
        deviceInfo.putString("sdk_version", RS_SDK_VERSION);
        deviceInfo.putString("os_version", Build.VERSION.RELEASE);
        s_deviceInfoBundle = deviceInfo;
        return deviceInfo;
    }

    @TargetApi(value=13)
    private static Bundle getDeviceParamsHoneycomb() {
        if (s_deviceInfoBundle != null) {
            return s_deviceInfoBundle;
        }
        Bundle deviceInfo = new Bundle();
        WindowManager wm = (WindowManager)s_application.getApplicationContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        TelephonyManager manager = (TelephonyManager)s_application.getApplicationContext().getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        Point displaySize = new Point();
        display.getSize(displaySize);
        deviceInfo.putString("screen_width", String.valueOf(displaySize.x));
        deviceInfo.putString("screen_height", String.valueOf(displaySize.y));
        deviceInfo.putString("carrier", carrierName);
        deviceInfo.putString("api_version", String.valueOf(Build.VERSION.SDK_INT));
        deviceInfo.putString("device", Build.DEVICE);
        deviceInfo.putString("hardware", Build.HARDWARE);
        deviceInfo.putString("manufacturer", Build.MANUFACTURER);
        deviceInfo.putString("model", Build.MODEL);
        deviceInfo.putString("product", Build.PRODUCT);
        deviceInfo.putString("sdk_version", RS_SDK_VERSION);
        deviceInfo.putString("os_version", Build.VERSION.RELEASE);
        s_deviceInfoBundle = deviceInfo;
        return deviceInfo;
    }

    private static JSONObject mergePayloadForActionBundle(Bundle parameters, Bundle deviceParamaters, Bundle eventParameters) {
        JSONObject jsonParameters = new JSONObject();
        if (eventParameters != null) {
            for (String key : eventParameters.keySet()) {
                try {
                    jsonParameters.put(key, eventParameters.get(key));
                }
                catch (JSONException e) {
                    RSClient.log(e.toString());
                }
            }
        }
        for (String key : parameters.keySet()) {
            try {
                if (parameters.get(key) instanceof Bundle) {
                    JSONObject bundle_parameters = new JSONObject();
                    Bundle bundle = (Bundle)parameters.get(key);
                    for (String bundle_key : bundle.keySet()) {
                        try {
                            bundle_parameters.put(bundle_key, bundle.get(bundle_key));
                        }
                        catch (JSONException e) {
                            RSClient.log(e.toString());
                        }
                    }
                    jsonParameters.put(key, (Object)bundle_parameters);
                    continue;
                }
                jsonParameters.put(key, parameters.get(key));
            }
            catch (JSONException e) {
                RSClient.log(e.toString());
            }
        }
        JSONObject json_device_parameters = new JSONObject();
        for (String key : deviceParamaters.keySet()) {
            try {
                json_device_parameters.put(key, deviceParamaters.get(key));
            }
            catch (JSONException e) {
                RSClient.log(e.toString());
            }
        }
        try {
            jsonParameters.put("device_info", (Object)json_device_parameters);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonParameters;
    }

    private static JSONObject mergePayloadForActionJSON(Bundle parameters, Bundle deviceParamaters, JSONObject eventParameters) {
        if (eventParameters == null) {
            eventParameters = new JSONObject();
        }
        for (String key : parameters.keySet()) {
            try {
                if (parameters.get(key) instanceof Bundle) {
                    JSONObject bundleParameters = new JSONObject();
                    Bundle bundle = (Bundle)parameters.get(key);
                    for (String bundle_key : bundle.keySet()) {
                        try {
                            bundleParameters.put(bundle_key, bundle.get(bundle_key));
                        }
                        catch (JSONException e) {
                            RSClient.log(e.toString());
                        }
                    }
                    eventParameters.put(key, (Object)bundleParameters);
                    continue;
                }
                eventParameters.put(key, parameters.get(key));
            }
            catch (JSONException e) {
                RSClient.log(e.toString());
            }
        }
        JSONObject jsonDeviceParameters = new JSONObject();
        for (String key : deviceParamaters.keySet()) {
            try {
                jsonDeviceParameters.put(key, deviceParamaters.get(key));
            }
            catch (JSONException e) {
                RSClient.log(e.toString());
            }
        }
        try {
            eventParameters.put("device_info", (Object)jsonDeviceParameters);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return eventParameters;
    }

    private static synchronized String getSessionKey(Long now_time) {
        Long lastUpdateTime = RSClient.getSharedPreferencesRS().getLong("last_updated", 0L);
        String currentSession = RSClient.getSharedPreferencesRS().getString("session_key", "");
        SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
        if (lastUpdateTime + (long)KEEP_SESSION_ALIVE < now_time) {
            RSClient.log("Starting a new session");
            currentSession = new BigInteger(130, s_random).toString(32);
            editor.putString("session_key", currentSession);
        }
        editor.putLong("last_updated", now_time.longValue());
        editor.commit();
        return currentSession;
    }

    public static String getUniqueDeviceId() {
        if (DEVICE_ID != "") {
            return DEVICE_ID;
        }
        String cachedDeviceId = RSClient.getSharedPreferencesRS().getString("device_id", "");
        if (cachedDeviceId == "") {
            PackageManager packageManager = RSClient.getApplicationContext().getPackageManager();
            if (packageManager.hasSystemFeature("android.hardware.telephony") && !ONLY_USE_GENERATED_UUIDS) {
                TelephonyManager tm = (TelephonyManager)RSClient.getApplicationContext().getSystemService("phone");
                String tmDevice = tm.getDeviceId();
                String tmSerial = tm.getSimSerialNumber();
                String androidId = Settings.Secure.getString((ContentResolver)RSClient.getApplicationContext().getContentResolver(), (String)"android_id");
                UUID deviceUUID = "9774d56d682e549c".equals(androidId) ? UUID.randomUUID() : new UUID(androidId.hashCode(), (long)tmDevice.hashCode() << 32 | (long)tmSerial.hashCode());
                String deviceId = deviceUUID.toString();
                SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
                System.out.println("ID: " + deviceId);
                editor.putString("device_id", deviceId);
                editor.commit();
                DEVICE_ID = deviceId;
                return deviceId;
            }
            SharedPreferences.Editor editor = RSClient.getSharedPreferencesRS().edit();
            String deviceId = UUID.randomUUID().toString();
            editor.putString("device_id", deviceId);
            editor.commit();
            DEVICE_ID = deviceId;
            return deviceId;
        }
        DEVICE_ID = cachedDeviceId;
        return cachedDeviceId;
    }

    private static String sha1Hash(String toHash) {
        String hash = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            byte[] bytes = toHash.getBytes("UTF-8");
            digest.update(bytes, 0, bytes.length);
            bytes = digest.digest();
            hash = RSClient.bytesToHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return hash;
    }

    private static void transmitTrackingEvent(final RSLogObject logObject) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RSClient.log("attempting to log event: " + logObject.getHash());
                HttpPost httpPost = new HttpPost(TARGET_SERVER);
                BasicNameValuePair trackingObjectPair = new BasicNameValuePair("wave", logObject.getTrackingString());
                ArrayList<BasicNameValuePair> nameValuePairList = new ArrayList<BasicNameValuePair>();
                nameValuePairList.add(trackingObjectPair);
                try {
                    UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(nameValuePairList);
                    httpPost.setEntity((HttpEntity)urlEncodedFormEntity);
                }
                catch (UnsupportedEncodingException uee) {
                    System.out.println("An Exception given because of UrlEncodedFormEntity argument :" + uee);
                    uee.printStackTrace();
                    RSClient.trackingEventInvalid(logObject);
                    RSClient.log(uee.getMessage());
                }
                if (DEBUG_MODE == 1) {
                    RSClient.trackingEventSuccess(logObject, "UNIT TEST SUCCESS OVERRIDE");
                } else if (DEBUG_MODE == 2) {
                    RSClient.trackingEventError(logObject, true);
                } else if (DEBUG_MODE == 3) {
                    RSClient.DEBUG_trackingEventCacheAndRemove(logObject);
                } else {
                    try {
                        HttpResponse httpResponse = s_httpClient.execute((HttpUriRequest)httpPost);
                        RSClient.trackingEventSuccess(logObject, EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
                    }
                    catch (ClientProtocolException cpe) {
                        RSClient.log("First Exception due to HttpResponese :" + cpe.getMessage());
                        RSClient.trackingEventError(logObject, true);
                    }
                    catch (IOException ioe) {
                        RSClient.log("Second Exception due to HttpResponse :" + ioe.getMessage());
                        RSClient.trackingEventError(logObject, true);
                    }
                    catch (Exception exception) {
                        RSClient.log("Generic Exception due to HttpResponse :" + exception.getMessage());
                        RSClient.trackingEventError(logObject, true);
                    }
                }
            }
        };
        s_eventThreadPool.execute(runnable);
    }

    private static void trackingEventError(RSLogObject logObject, boolean isCached) {
        if (isCached) {
            RSClient.cacheTrackEvent(logObject);
        }
        s_mainQueue.add(logObject);
    }

    private static void trackingEventInvalid(RSLogObject logObject) {
        RSClient.removeCachedTrackEvent(logObject);
        RSClient.log("Log Invalid for " + logObject.getHash());
    }

    private static void trackingEventSuccess(RSLogObject logObject, String response) {
        RSClient.removeCachedTrackEvent(logObject);
        RSClient.log("Log Success for " + logObject.getHash());
        if (SHOW_VERBOSE_LOGS) {
            RSClient.log(logObject.getTrackingString());
        }
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    private static long getSystemTime() {
        long unixTime = System.currentTimeMillis() / 1000L;
        return unixTime;
    }

    private static Context getApplicationContext() {
        return s_application.getApplicationContext();
    }

    private static int getCoreUsage() {
        int halfOfCores = NUMBER_OF_CORES / 2;
        if (halfOfCores > 1) {
            return halfOfCores;
        }
        return 1;
    }

    public static void DEBUG_enableDeveloperMode() {
        TARGET_SERVER = DEVELOPEMENT_SERVER;
    }

    private static void DEBUG_trackingEventCacheAndRemove(RSLogObject logObject) {
        RSClient.log("Object being cached and removed");
        RSClient.cacheTrackEvent(logObject);
        RSClient.DEBUG_removeObjectFromMainQueue(logObject);
    }

    private static void DEBUG_removeObjectFromMainQueue(RSLogObject logObject) {
        s_mainQueue.remove(logObject);
        RSClient.log("logObject removed from active queue. Remaining:  " + s_mainQueue.size());
    }

    public static void DEBUG_enableAllSuccess() {
        DEBUG_MODE = 1;
    }

    public static void DEBUG_enableAllFailure() {
        DEBUG_MODE = 2;
    }

    public static void DEBUG_enableAllCacheAndDelete() {
        DEBUG_MODE = 3;
    }

    public static void DEBUG_enableAllDefault() {
        DEBUG_MODE = 0;
    }

    public static String DEBUG_getStatusForDebugging() {
        String line1 = String.valueOf(s_mainQueue.size()) + " Open Calls\n";
        String line2 = "0 Standby Calls\n";
        String line3 = String.valueOf(RSClient.getCachedEventsCount()) + " Cached Calls\n";
        String line4 = "\n";
        return String.valueOf(line1) + line2 + line3 + line4;
    }
}

